#ifndef __NeptuneCommon_H__
#define __NeptuneCommon_H__

#ifdef WIN32
	#pragma warning( disable : 4786 ) // VC ł̌x菜܂B
#endif//WIN32

#include <vector>
#include <string>
#include <map>
#include <list>


//	namespace
#define NEPLIB_NS_START		namespace neplib {
#define NEPLIB_NS_END		}//namespace neplib

//	dllexport
#ifdef NEPTUNELIB_EXPORTS
	#define NEPDLL_EXP __declspec(dllexport)
#else
	#define NEPDLL_EXP __declspec(dllimport)
#endif

//// F //////////////////////////////////////////////////

#ifndef NEPTUNE_COLOR_DEFINED
typedef DWORD NEPTUNE_COLOR;
typedef DWORD NEPCOLOR;
#define NEPTUNE_COLOR_DEFINED
#endif

#define NEPCOLOR_ARGB(a,r,g,b) \
    ((NEPCOLOR)((((a)&0xff)<<24)|(((r)&0xff)<<16)|(((g)&0xff)<<8)|((b)&0xff)))
#define NEPCOLOR_RGBA(r,g,b,a) NEPCOLOR_ARGB(a,r,g,b)
#define NEPCOLOR_XRGB(r,g,b)   NEPCOLOR_ARGB(0xff,r,g,b)

///// From MGL //////////

#define NEPCOLOR_A(a)			((NEPCOLOR)((((a)&0xff)<<24)|(0x00ffffff)))
#define NEPCOLORW_A(a)			NEPCOLOR_A(WrapByte(a))
#define NEPCOLORW_ARGB(a,r,g,b)	NEPCOLOR_ARGB(WrapByte(a),WrapByte(r),WrapByte(g),WrapByte(b))
#define NEPCOLORW_RGBA(r,g,b,a)	NEPCOLOR_RGBA(WrapByte(r),WrapByte(g),WrapByte(b),WrapByte(a))
#define NEPCOLORW_XRGB(r,g,b)	NEPCOLOR_XRGB(WrapByte(r),WrapByte(g),WrapByte(b))

//	̂[
#define NEPCOLOR_MONO(v)		NEPCOLOR_XRGB(v,v,v)
#define NEPCOLORW_MONO(v)		NEPCOLOR_XRGB(WrapByte(v),WrapByte(v),WrapByte(v))

#define NEPCOLOR_BLUE			((NEPCOLOR)0xff0000ff)
#define NEPCOLOR_GREEN			((NEPCOLOR)0xff00ff00)
#define NEPCOLOR_RED			((NEPCOLOR)0xffff0000)
#define NEPCOLOR_PINK			((NEPCOLOR)0xffff00ff)
#define NEPCOLOR_CYAN			((NEPCOLOR)0xff00ffff)
#define NEPCOLOR_YELLOW			((NEPCOLOR)0xffffff00)
#define NEPCOLOR_WHITE			((NEPCOLOR)0xffffffff)
#define NEPCOLOR_BLACK			((NEPCOLOR)0xff000000)
#define NEPCOLOR_FULLWHITE		((NEPCOLOR)0xffffffff)	//	NEPCOLOR_WHITEɓ

#define NEPCOLOR_NABLUE			((NEPCOLOR)0x000000ff)
#define NEPCOLOR_NAGREEN		((NEPCOLOR)0x0000ff00)
#define NEPCOLOR_NARED			((NEPCOLOR)0x00ff0000)
#define NEPCOLOR_NAPINK			((NEPCOLOR)0x00ff00ff)
#define NEPCOLOR_NACYAN			((NEPCOLOR)0x0000ffff)
#define NEPCOLOR_NAYELLOW		((NEPCOLOR)0x00ffff00)
#define NEPCOLOR_NAWHITE		((NEPCOLOR)0x00ffffff)
#define NEPCOLOR_NABLACK		((NEPCOLOR)0x00000000)

#define NEPCOLOR_FULLALPHA		((NEPCOLOR)0xff000000)
#define NEPCOLOR_ZEROALPHA		((NEPCOLOR)0x00000000)

//	tB^[
#define NEPCOLOR_ZEROALPHA_FILTER(COLOR)	(COLOR&0x00ffffff)
#define NEPCOLOR_FULLALPHA_FILTER(COLOR)	(COLOR|0xff000000)


///////////////////////////////////////////////////////////


#endif//__NeptuneCommon_H__
